%% Description
% Plots figure 4: phase diagram showing number and type of solution in the
% (H_\infty,\Gamma)-plane.
%
% Sometimes doesn't work first time - try running twice in a row.

%% Parameter Definitions
%
% G     Values of \Gamma.
%
% a     Smallest value of H_\infty where solution is valid (RM=1) for each
%       \Gamma.
%
% b     Smallest value of H_\infty where 3 solutions exist together for
%       each \Gamma.
%
% c     Largest value of H_\infty where 3 solutions exist together for
%       each \Gamma.

clear all;close all;


%% Load data
load('figure4.mat')

%% Plot boundaries
figure(1)
loglog(G,a,G,b,G,c)

%% Add hatching
h = findobj(gca,'Type','line');
x = get(h,'Xdata');
y = get(h,'Ydata');

figure(2); box on; hold on;
figpref(4)
col = parula(5);

xx = 1e1:1:1e4; yy = zeros(size(xx)); yy(:) = 100;
a0 = area(xx,yy,'FaceColor','w','linewidth',2);
hatchfill2(a0,'HatchStyle','single','HatchColor',col(2,:))
%label(1) = string('1 non-contact solution');

a1 = area(x{1,1},y{1,1},'FaceColor','w');
a1_2 = area(x{1,1},y{1,1},'linewidth',2);
hatchfill2(a1_2,'HatchStyle','cross','HatchColor',col(3,:))
%label(2) = string('3 solutions');

a2 = area(x{2,1},y{2,1},'FaceColor','w');
a2_2 = area(x{2,1},y{2,1},'linewidth',2);
hatchfill2(a2_2,'HatchStyle','single','HatchAngle',-45,'HatchColor',col(4,:))
%label(3) = string('1 contact solutions');

a3 = area(x{3,1},y{3,1},'FaceColor','w','linewidth',2);
%label(4) = string('0 solutions');

%legend(label)
xlabel('$\Gamma$','interpreter','latex')
ylabel('$H_{\infty}$','interpreter','latex')
ylim([1e-2 100])

plot(x{1,1},y{1,1},'k','LineWidth',2)
plot(x{2,1},y{2,1},'k','LineWidth',2)
plot(x{3,1},y{3,1},'k','LineWidth',2)

set(gca,'xscale','log')
set(gca,'yscale','log')

axis([1e1 1e4 1e0 1e2])

% Increase axis label size
set(findobj('type','axes'),'fontsize',20,'linewidth',2)

% Increase tick length
set(gca,'TickLength',2*get(gca,'TickLength'))
